<?php
include 'conexao.php';

// Buscar lista de alunos
$alunos = [];
$res = $conn->query("SELECT id, nome FROM alunos ORDER BY nome");
while ($row = $res->fetch_assoc()) {
    $alunos[] = $row;
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Gerar Certificado</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f2f2f2;
            padding: 50px;
            text-align: center;
        }
        select {
            padding: 10px;
            width: 300px;
            font-size: 16px;
            margin-top: 20px;
        }
        h2 {
            margin-bottom: 30px;
        }
    </style>
</head>
<body>

    <h2>Selecionar Aluno para Gerar Certificado</h2>

    <select id="aluno" onchange="gerarCertificado()">
        <option value="">-- Escolha um aluno --</option>
        <?php foreach ($alunos as $a): ?>
            <option value="<?= $a['id'] ?>"><?= htmlspecialchars($a['nome']) ?></option>
        <?php endforeach; ?>
    </select>

    <script>
        function gerarCertificado() {
            const alunoId = document.getElementById('aluno').value;
            if (alunoId) {
                window.open('gerar_certificado.php?aluno_id=' + alunoId, '_blank');
            }
        }
    </script>

</body>
</html>
